<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Fortify\TwoFactorAuthenticatable;
use Laravel\Jetstream\HasProfilePhoto;
use Laravel\Sanctum\HasApiTokens;
class Usuario extends Authenticatable{
    use HasApiTokens;
    use HasFactory;
    use HasProfilePhoto;
    use Notifiable;
    use TwoFactorAuthenticatable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
//    protected $connection = 'cloud';
    protected $table = 'sistema_usuario';
    protected $fillable = [
        'email', 'password',
    ];
    protected $appends = ['persona'];
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token', 'created_at', 'email_verified_at'
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function persona()
    {
        return $this->hasOne('App\Models\Persona', 'usuario_id', 'id');
    }
    public function firma()
    {
        return $this->hasOne('App\Models\Firma', 'usuario_id', 'id');
    }
    public function identities() {
        return $this->hasOne('App\Models\Identity');
    }
    public function getPersonaAttribute() {
        return $this->persona()->first();
//        ->where('column','value')
    }
}
