<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Persona;
use App\Models\Unidad;
use App\Models\Usuario;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Modules\Mailing\Entities\MailingListaUsuario;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Input;
use Illuminate\Database\Eloquent\Builder;
use Schema;

class UsuarioController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function js(){
        $Usuarios = Usuario::with(['persona', 'identities', 'firma'])->orderBy('id', 'asc')->get();
        return ['Nombre' => 'Usuarios', 'Contenido' => $Usuarios];
    }
    public
    function json( Request $request ) {
        $Usuarios = Usuario::whereHas('persona', function (Builder $query) {
            $query->where('estado',  1);
            $query->orderBy('apellido_paterno', 'asc');
        });

        if( $request->input('q')){
            $searchText = $request['q'];
            $Usuarios = $Usuarios->orWhere('email', 'like', '%' . $searchText . '%');
            $Usuarios = $Usuarios->orWhereHas('persona', function (Builder $query) use ($searchText) {
                $query->where(function($query) use ($searchText) {
                    $ColumnasPersona = ['nombre', 'apellido_paterno', 'apellido_materno', 'cargo', 'codigo', 'dni', 'area'];
                    foreach ($ColumnasPersona as $ColumnaPer) {
                        $query->orWhere($ColumnaPer, 'like', '%' . $searchText . '%');
                    }
                });
            });

        }
        $Usuarios = $Usuarios->get();
        if ( $request->input( 'secure' ) && $request->input( 'secure' ) == true) {
            $Usuarios = $Usuarios->whereNotIn('id', [Auth::id()]);
        }
        if ( $request->input( 'exclude' )) {
            $Usuarios = $Usuarios->whereNotIn('id', [$request['exclude']]);
        }
        $Lista = [];
        foreach($Usuarios as $Usuario){
            $Lista[] = [
                'id' => $Usuario->id,
                'correo' => $Usuario->email,
//                'area' =>$Usuario->persona['area'],
//                'cargo' => $Usuario->persona['cargo'],
//                'foto' => $Usuario->identities()->where('provider_nombre', 'google')->value('avatar'),
                'text' => $Usuario->persona['nombre_completo'],
            ];
        }
        usort($Lista, function($a, $b) {
            return $a['text'] <=> $b['text'];
        });
//        return [ 'items' => $Lista ];
        return ['Nombre' => 'Usuarios', 'Contenido' => $Lista];
    }

}
