<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Builder;
use App\Models\Usuario;
use Illuminate\Support\Facades\Storage;
use Inertia\Inertia;

class PrincipalController extends Controller
{
    public function index()
    {
        $Usuarios = Usuario::whereHas('persona', function (Builder $query) {
            $query->where('estado',  1);
        })->with(['persona', 'identities', 'firma'])->orderBy('id', 'asc')->get();
        $Listador = [];
        foreach($Usuarios as $Usuario){
            $Listador[] = ['code' => $Usuario->id, 'name'=>$Usuario->persona->nombre_completo];
        }
        return Inertia::render('Dashboard',[
            'MisUsuarios' => $Usuarios,
            'MiListador' => $Listador
        ]);
    }

    public function create()
    {
        //
    }

    public function defecto(Request $request)
    {
//        dd($request->all());
        $Usuario = Usuario::find($request->input('id'));
        Storage::disk('publico')->put(
            '/img/foto/google-'.$Usuario->id.'.png',
            file_get_contents(storage_path('app').'/template/avatar-'.$Usuario->persona->genero.'.png')
        );
        return [
            'resultado' => true,
            'imagen' => Storage::disk('publico')->url('img/foto/google-'.$Usuario->id.'.png')
        ];
    }
    public function upload(Request $request)
    {
//        dd($request->all());
//        Storage::disk('publico')->put('/img/foto/google-'.$request->input('id').'.png', $request->file('img'));
        Storage::disk('publico')->putFileAs(
            '/img/foto/', $request->file('img'), 'google-'.$request->input('id').'.png'
        );
        return [
            'resultado' => true,
            'imagen' => Storage::disk('publico')->url('img/foto/google-'.$request->input('id').'.png')
        ];
    }
    public function googlefoto(Request $request)
    {
        $Usuario = Usuario::find($request->input('id'));
        if($Usuario) {
            $unidad = $this->ObtenerUnidad($Usuario->email);
            $google = $this->Google($unidad);
            $service_google = new \Google_Service_Directory($google);
            $avatar_google = $service_google->users->get($Usuario->email)->getThumbnailPhotoUrl();
            if ($avatar_google) {
                Storage::disk('publico')->put('/img/foto/google-' . $Usuario->id . '.png', file_get_contents($avatar_google));
                return [
                    'resultado' => true,
                    'imagen' => Storage::disk('publico')->url('img/foto/google-' . $Usuario->id . '.png')
                ];
            }
        }
    }

    public function show(string $id)
    {
        $Usuario = Usuario::find($id);
        if (Storage::disk('publico')->exists('img/foto/google-'.$id.'.png')) {
            return [
              'resultado' => true,
              'imagen' => Storage::disk('publico')->url('img/foto/google-'.$id.'.png')
            ];
        }elseif($Usuario){
            $unidad = $this->ObtenerUnidad($Usuario->email);
            $google = $this->Google($unidad);
            $service_google = new \Google_Service_Directory($google);
            $avatar_google = $service_google->users->get($Usuario->email)->getThumbnailPhotoUrl();
            if($avatar_google){
                Storage::disk('publico')->put('/img/foto/google-'.$id.'.png', file_get_contents($avatar_google));
                return [
                    'resultado' => true,
                    'imagen' => Storage::disk('publico')->url('img/foto/google-'.$id.'.png')
                ];
            }
            return [
                'resultado' => false
            ];
        }

    }

    public function ObtenerUnidad($correo)
    {
        $dominio = substr($correo, strpos($correo, '@') + 1);
        switch ($dominio) {
            case 'khipu.net':
            case 'incalab.org':
            case 'khipu.plus':
                $unidad = 'corporacion';
                break;
            case 'khipu.edu.pe':
                $unidad = 'instituto';
                break;
            case 'escuelakhipu.edu.pe':
            default:
                $unidad = 'escuela';
                break;
        }
        return $unidad;
    }

    public function update(Request $request, string $id)
    {
        //
    }

    public function destroy(string $id)
    {
        //
    }
    public function Google($unidad){
        $client = new \Google_Client();
        $client->setApplicationName('GSuiteAdministrador');
        $client->setScopes([
            \Google_Service_Directory::ADMIN_DIRECTORY_USER,
            \Google_Service_Directory::ADMIN_DIRECTORY_USER_READONLY,
            //\Google_Service_Directory::ADMIN_DIRECTORY_MEMBER,
            //\Google_Service_Directory::ADMIN_DIRECTORY_USERNAME,
            \Google_Service_Directory::ADMIN_DIRECTORY_GROUP,
            \Google_Service_Directory::ADMIN_DIRECTORY_GROUP_MEMBER
        ]);
        $client->setAuthConfig(storage_path('app').'/json/'.$unidad.'/credentials.json');
        $client->setAccessType('offline');
        $client->setPrompt('select_account consent');
        $tokenPath = storage_path('app').'/json/'.$unidad.'/token.json';
        if (file_exists($tokenPath)) {
            $accessToken = json_decode(file_get_contents($tokenPath), true);
            $client->setAccessToken($accessToken);
        }
        if ($client->isAccessTokenExpired()) {
            // Refresh the token if possible, else fetch a new one.
            if ($client->getRefreshToken()) {
                $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
            } else {
                $authCode = '';
                if ($authCode) {
                    $authUrl = $client->createAuthUrl();
                    return $authUrl;
                }
                $authCode = '4/RgGN9FQybQIqFdQS3Zywm4yyFrZP_HrJO2h8Rzp415EExzREgWhorBs';
                // Exchange authorization code for an access token.
                $accessToken = $client->fetchAccessTokenWithAuthCode($authCode);
                $client->setAccessToken($accessToken);
                // Check to see if there was an error.
                if (array_key_exists('error', $accessToken)) {
                    throw new Exception(join(', ', $accessToken));
                }
            }
            // Save the token to a file.
            if (!file_exists(dirname($tokenPath))) {
                mkdir(dirname($tokenPath), 0700, true);
            }
            file_put_contents($tokenPath, json_encode($client->getAccessToken()));
        }
        return $client;
    }
}
