<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Firma;
use App\Models\Usuario;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;
use Intervention\Image\Geometry\Factories\LineFactory;
use Intervention\Image\Decoders\FilePathImageDecoder;
use Intervention\Image\Decoders\DataUriImageDecoder;
use Intervention\Image\Decoders\Base64ImageDecoder;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\Storage;


class FirmasController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
//        $client = $this->Google();
//        $service = new \Google_Service_Directory($client);
//        $Usuario = $service->users->get('jparedes@khipu.net');
//        return $Usuario->getThumbnailPhotoUrl();
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {

        if ( !is_array( $request->all() ) ) {
            return [ 'Resultado'=> false, 'Error' => 'Debes Ingresar los campos requeridos' ];
        }
        $respuestas = [
            'required' => ':attribute es requerido.'
        ];
        $reglas_mensajes = [
            'id' => 'required'
        ];
        try {
            $validar_mensaje = \Validator::make( $request->all(), $reglas_mensajes, $respuestas );
            if ( $validar_mensaje->fails() ) {
                return [ 'Resultado' => false, 'Error' => $validar_mensaje->errors()->all() ];
            }
            $Data = [];
            $Data['telefono'] = [
                'anexo' => $request->input('anexo')
            ];
            $Data['logos'] = [];
            foreach( $request->input('logos') as $item){
                $Data['logos'][] = [$item => 0];
            }
            $Data['logos'] = array_merge(...$Data['logos']);
            $Data['informacion'] = [
                'cargo' => $request->input('cargo'),
                'telefono' => $request->input('telefono')
            ];
//            $Data = array_reduce($Data, 'array_merge', array());

//            $Firmas = Firma::where('usuario_id', $request->input('usuario'))->delete();
            $Firma = Firma::updateOrCreate(
                ['usuario_id' => $request->input('id')],
                ['opciones' => json_encode($Data, true)]
            );

            return [ 'Resultado' => true, 'firma_id' => $Firma->id ];

        } catch ( Exception $e ) {
            return \Response::json( [ 'Resultado' => false ], 500 );
        }
    }
    function array_flatten($array) {
        if (!is_array($array)) {
            return false;
        }
        $result = array();
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                $result = array_merge($result, $this->array_flatten($value));
            } else {
                $result = array_merge($result, array($key => $value));
            }
        }
        return $result;
    }
    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $Firma = Firma::find($id);
        if(!$Firma){
            return redirect()->away('https://khipu.net');
        }
        $Opciones = json_decode($Firma->opciones, true);

        $TelefonoAnexo = false;
        $InformacionCargo = false;
        $InformacionTelefono = false;

        $ArrayLogos = [
            'corporacion'     => ['imagen' => 'corporacion-logo.png', 'web' => 'khipu.net', 'posicion' => ['top' => 150]],
            'instituto'       => ['imagen' => 'instituto-khipu-logo.png', 'web' => 'khipu.edu.pe', 'posicion' => ['top' => 150]],
            'idiomas'        => ['imagen' => 'centro-idiomas-logo.png', 'web' => 'idiomaskhipu.edu.pe', 'posicion' => ['top' => 150]],
            'formacion'       => ['imagen' => 'unidad-formacion-logo.png', 'web' => 'khipu.edu.pe', 'posicion' => ['top' => 150]],
            'escuela'        => ['imagen' => 'escuela-khipu-logo.png', 'web' => 'escuelakhipu.edu.pe', 'posicion' => ['top' => 150]]
        ];

        if($Opciones['telefono']){
            if($Opciones['telefono']['anexo']){
                $TelefonoAnexo = $Opciones['telefono']['anexo'];
            }
        }

        if($Opciones['informacion']){
            if($Opciones['informacion']['cargo']){
                $InformacionCargo = $Opciones['informacion']['cargo'];
            }
            if(isset($Opciones['informacion']['telefono'])){
                $InformacionTelefono = $Opciones['informacion']['telefono'];
            }
        }

        $FuentePrincipal = storage_path('app').'/fonts/Roboto-Regular.ttf';
        $FuentePrincipalLight = storage_path('app').'/fonts/Roboto-Light.ttf';
        $FuentePrincipalBold = storage_path('app').'/fonts/Roboto-Bold.ttf';

        $ColorTexto = '#333';
        $ColorFondo = 'FFF';

        $Usuario = Usuario::find($Firma->usuario_id);

        $manager = new ImageManager(Driver::class);
        $IconBg = $manager->create(15, 15)->fill('1B4587');
        $image = $manager->create(728, 270)->fill($ColorFondo);

        $image->text($Usuario->persona->nombre, 120, 30, function ($font) use ($ColorTexto, $FuentePrincipalBold) {
            $font->file($FuentePrincipalBold);
            $font->size(20);
            $font->color('#1B4587');
        });
        $image->text($Usuario->persona->apellidos, 120, 47, function ($font) use ($ColorTexto, $FuentePrincipalLight) {
            $font->file($FuentePrincipalLight);
            $font->size(17);
            $font->color('#1B4587');
        });

        $Cargo = explode('/', $InformacionCargo, 2);
        $CargoCantidad = count($Cargo);
        if($CargoCantidad == 2){
            foreach($Cargo as $i => $key) {
                $image->text($key, 120, 65+($i*15), function ($font) use ($ColorTexto, $FuentePrincipal) {
                    $font->file($FuentePrincipal);
                    $font->size(13);
                    $font->color($ColorTexto);
                });
            }
        }else{
            $image->text($InformacionCargo, 120, 65, function ($font) use ($ColorTexto, $FuentePrincipal) {
                $font->file($FuentePrincipal);
                $font->size(13);
                $font->color($ColorTexto);
            });
        }

        $image->text('Corporaci贸n Khipu SAC', 120, 80+($CargoCantidad*10), function ($font) use ($ColorTexto, $FuentePrincipal) {
            $font->file($FuentePrincipal);
            $font->size(13);
            $font->color('#292a2c');
        });

        $image->text('Cusco - Per煤', 120, 95+($CargoCantidad*10), function ($font) use ($ColorTexto, $FuentePrincipal) {
            $font->file($FuentePrincipal);
            $font->size(13);
            $font->color('#292a2c');
        });

        $IconPhone = $manager->read(storage_path('app').'/template/phone-icon.png')->resize(15,15);
        if ($InformacionTelefono == 1) {
            $image->place($IconBg, 'top-right', 225, 13);
            $image->place($IconPhone, 'top-right', 225, 13);
            $image->text($Usuario->persona->telefono, 510, 25, function ($font) use ($ColorTexto, $FuentePrincipal) {
                $font->file($FuentePrincipal);
                $font->size(12);
                $font->color($ColorTexto);
            });
        }

        $image->place($IconBg, 'top-right', 225, 35);
        $image->place($IconPhone, 'top-right', 225, 35);
        $image->text(($TelefonoAnexo)? '084 - 227955 Anexo: '.$TelefonoAnexo: '084 - 227955', 510, 49, function($font) use ($ColorTexto, $FuentePrincipal){
            $font->file($FuentePrincipal);
            $font->size(12);
            $font->color($ColorTexto);
        });

        $IconMail = $manager->read(storage_path('app').'/template/mail-icon.png')->resize(15, 15);
        $image->place($IconBg, 'top-right', 225, 58);
        $image->place($IconMail, 'top-right', 225, 58);
        $image->text($Usuario->email, 510, 70, function($font) use ($ColorTexto, $FuentePrincipal){
            $font->file($FuentePrincipal);
            $font->size(12);
            $font->color($ColorTexto);
        });

        $IconMap =  $manager->read(storage_path('app').'/template/map-icon.png')->resize(15, 15);
        $image->place($IconBg, 'top-right', 225, 82);
        $image->place($IconMap, 'top-right', 225, 82);
        $image->text('Av. Camino Real Nro. 443', 510, 93, function($font) use ($ColorTexto, $FuentePrincipal){
            $font->file($FuentePrincipal);
            $font->size(12);
            $font->color($ColorTexto);
        });

        $FotoPersonal = $manager->read(storage_path('../public').'/img/foto/google-'.$Usuario->id.'.png')->resize(100, 100);

        $image->place($FotoPersonal->crop(98, 98, 0, 0), 'top-left', 12, 12);

        $CapaFoto = $manager->read(storage_path('app').'/template/circulo-foto.png')->resize(100, 100);
        $image->place($CapaFoto, 'top-left', 10, 10);

        $image->drawLine(function (LineFactory $line) {
            $line->from(370, 10); // starting point of line
            $line->to(370, 110); // ending point
            $line->color('1B4587'); // color of line
            $line->width(3); // line width in pixels
        });

        $image->drawLine(function (LineFactory $line) {
            $line->from(10, 135); // starting point of line
            $line->to(718, 135); // ending point
            $line->color('1B4587'); // color of line
            $line->width(3); // line width in pixels
        });

        $vCard = "BEGIN:VCARD\n";
        $vCard .= "VERSION:2.1\n";
        $vCard .= "FN:{$Usuario->persona->apellidos} {$Usuario->persona->nombre}\n";
        $vCard .= "N:{$Usuario->persona->apellido_paterno};{$Usuario->persona->apellido_materno};{$Usuario->persona->nombre}\n";
        $vCard .= "TITLE:{$InformacionCargo}\n";
        if ($InformacionTelefono == 1) {
            $vCard .= "TEL;WORK;VOICE:{$Usuario->persona->telefono}\n";
        }
        $vCard .= "EMAIL;WORK:{$Usuario->email}\n";
        $vCard .= "ORG:Corporacion Khipu S.A.C\n";
        $vCard .= "END:VCARD";
        $QrCode= $manager->read(base64_encode(QrCode::color(27,69,135)->format('png')->generate($vCard)), Base64ImageDecoder::class);
        $image->place($QrCode, 'top-right', 248, 10);

        $espacio_left = 15;
        foreach($ArrayLogos as $empresa => $logo){
            if(array_key_exists($empresa, $Opciones['logos'])){
                $logo = json_decode(json_encode($logo), FALSE);
                $LogoCorporacion = $manager->read(storage_path('app')."/template/logos/{$logo->imagen}")->scale(width: 120);
                $image->place($LogoCorporacion, 'top-left', $espacio_left, $logo->posicion->top);
                $espacio_left = $espacio_left + 135;
            }
        }

        $firma = $image->toJpeg();
        Storage::disk('s3')->delete('/firma/'.$id.'.png');
        Storage::disk('s3')->put('/firma/'.$id.'.png', $firma);
        return [
            'imagen' => 'https://firma.khipu.edu.pe/'.$id.'.png',
            'hash' => \Str::random(100)
        ];
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
    public function Google($unidad){
        $client = new \Google_Client();
        $client->setApplicationName('GSuiteAdministrador');
        $client->setScopes([
            \Google_Service_Directory::ADMIN_DIRECTORY_USER,
            \Google_Service_Directory::ADMIN_DIRECTORY_USER_READONLY,
            //\Google_Service_Directory::ADMIN_DIRECTORY_MEMBER,
            //\Google_Service_Directory::ADMIN_DIRECTORY_USERNAME,
            \Google_Service_Directory::ADMIN_DIRECTORY_GROUP,
            \Google_Service_Directory::ADMIN_DIRECTORY_GROUP_MEMBER
        ]);
        $client->setAuthConfig(storage_path('app').'/json/'.$unidad.'/credentials.json');
        $client->setAccessType('offline');
        $client->setPrompt('select_account consent');
        $tokenPath = storage_path('app').'/json/'.$unidad.'/token.json';
        if (file_exists($tokenPath)) {
            $accessToken = json_decode(file_get_contents($tokenPath), true);
            $client->setAccessToken($accessToken);
        }
        if ($client->isAccessTokenExpired()) {
            // Refresh the token if possible, else fetch a new one.
            if ($client->getRefreshToken()) {
                $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
            } else {
                $authCode = '';
                if ($authCode) {
                    $authUrl = $client->createAuthUrl();
                    return $authUrl;
                }
                $authCode = '4/RgGN9FQybQIqFdQS3Zywm4yyFrZP_HrJO2h8Rzp415EExzREgWhorBs';
                // Exchange authorization code for an access token.
                $accessToken = $client->fetchAccessTokenWithAuthCode($authCode);
                $client->setAccessToken($accessToken);
                // Check to see if there was an error.
                if (array_key_exists('error', $accessToken)) {
                    throw new Exception(join(', ', $accessToken));
                }
            }
            // Save the token to a file.
            if (!file_exists(dirname($tokenPath))) {
                mkdir(dirname($tokenPath), 0700, true);
            }
            file_put_contents($tokenPath, json_encode($client->getAccessToken()));
        }
        return $client;
    }
}
