<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Carbon\Carbon;
use GuzzleHttp\Client;
use App\Models\Persona;
use Illuminate\Support\Facades\Log;
use App\Models\Firma;
class ActualizarPersonalCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'personal:actualizar';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $client = new Client(['base_uri' => 'http://nava-api.khipu.net/public/api/']);
        $response = $client->request('GET', 'PersonalActive');
        $Personal = json_decode( $response->getBody(), false );
        $NuevoPersonal = [];
        Persona::query()->update(['estado' => 0]);
        foreach($Personal as $Persona){
            Log::debug("Codigo: ".$this->titleCase($Persona->codtra));
            Log::debug($this->titleCase($Persona->pattra) ." ".$this->titleCase($Persona->mattra) .", ".$this->titleCase($Persona->nomtra));
            Log::debug("Iniciar...");
            $NuevoPersonal = Persona::updateOrCreate(                [
                    'codigo' => $this->titleCase($Persona->codtra),
                    'dni' => (int) strval($this->titleCase($Persona->nrodni)),
                ],
                [
                    'estado' => 1,
                    'nombre' => $this->titleCase($Persona->nomtra),
                    'apellido_paterno' => $this->titleCase($Persona->pattra),
                    'apellido_materno' => $this->titleCase($Persona->mattra),
                    'genero' => $this->titleCase($Persona->sextra),
                    'telefono' => $this->titleCase($Persona->teltra),
                    'birthday_at' => Carbon::parse($Persona->fecnac)->toDateTime(),
                    'entry_at' => Carbon::parse($Persona->fecing)->toDateTime(),
                    'correo_personal' => trim(strtolower($Persona->dirmai)),
                    'area' => $this->Capitalizar($Persona->nomsec),
                    'cargo' => $this->titleCase($Persona->nomcar),
                ]
            );  
            if($NuevoPersonal->usuario){
                $Data = [
                    'telefono'=> [
                        'anexo' => null
                    ],
                    'logos' => ["escuela" => "0", "idiomas" => "0", "formacion"=> "0"],
                    'informacion' => [
                        'cargo' => $this->titleCase($Persona->nomcar),
                        'telefono' => $this->titleCase($Persona->teltra)
                    ]
                ];
                Firma::updateOrCreate(
                    ['usuario_id' => $NuevoPersonal->usuario->id],
                    ['opciones' => json_encode($Data, true)]
                );
                Log::debug("Finalizar...");
            }
        }
    }
    public function OptimizarTexto($text){
//        $texto = mb_convert_case($texto, MB_CASE_TITLE, "UTF-8");
//        return ucwords(strtolower(trim($texto)));
        $articulos = array(' a',' al',' de',' del',' lo',' el',' la',' los',' las',' un',' una',' unos',' unas', 'y');
        // Signos de puntucacion, despues de uno de estos va mayuscula.
        $puntucacion = array('.');
        $text = mb_convert_case(trim(str_replace("  ", " ", trim($text))), MB_CASE_TITLE, "UTF-8");
        // Identificar cada signo de puntucion.
        $text = str_replace(array_map(function($e) { return "$e "; }, $puntucacion), $puntucacion, $text);
        $text = str_ireplace($articulos, $articulos, $text);
        $text = str_replace($puntucacion, array_map(function($e) { return "$e "; }, $puntucacion), $text);

        return $text;
    }
    public	function Capitalizar( $text ) {
        $articulos = array( ' a', ' y', ' al', ' de', ' del', ' lo', ' el', ' la', ' los', ' las', ' un', ' una', ' unos', ' unas' );
        $puntucacion = array( '.' );
        $text = mb_convert_case( trim( str_replace( "  ", " ", trim($text) ) ), MB_CASE_TITLE, "UTF-8" );
        $text = str_replace( array_map( function ( $e ) {
            return "$e ";
        }, $puntucacion ), $puntucacion, $text );
        $text = str_ireplace( $articulos, $articulos, $text );
        $text = str_replace( $puntucacion, array_map( function ( $e ) {
            return "$e ";
        }, $puntucacion ), $text );
        return $text;
    }
    function titleCase($string, $delimiters = array(" ", "-", ".", "'", "O'", "Mc"), $exceptions = array("de", "la"))
    {
        /*
         * Exceptions in lower case are words you don't want converted
         * Exceptions all in upper case are any words you don't want converted to title case
         *   but should be converted to upper case, e.g.:
         *   king henry viii or king henry Viii should be King Henry VIII
         */
        $string = mb_convert_case($string, MB_CASE_TITLE, "UTF-8");
        foreach ($delimiters as $dlnr => $delimiter) {
            $words = explode($delimiter, $string);
            $newwords = array();
            foreach ($words as $wordnr => $word) {
                if (in_array(mb_strtoupper($word, "UTF-8"), $exceptions)) {
                    // check exceptions list for any words that should be in upper case
                    $word = mb_strtoupper($word, "UTF-8");
                } elseif (in_array(mb_strtolower($word, "UTF-8"), $exceptions)) {
                    // check exceptions list for any words that should be in upper case
                    $word = mb_strtolower($word, "UTF-8");
                } elseif (!in_array($word, $exceptions)) {
                    // convert to uppercase (non-utf8 only)
                    $word = ucfirst($word);
                }
                array_push($newwords, $word);
            }
            $string = join($delimiter, $newwords);
        }//foreach
        return trim($string);
    }
}
