<?php

use App\Models\Usuario;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Foundation\Application;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;
use App\Http\Controllers\GoogleController;
use App\Http\Controllers\UsuarioController;
use App\Http\Controllers\FirmasController;
use App\Http\Controllers\PrincipalController;
use App\Http\Controllers\LimpiezaController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::middleware(['auth:sanctum', config('jetstream.auth_session'), 'verified'])->group(function () {
    Route::get('/', function () {
        return redirect()->intended('dashboard');
    });
    Route::get('/dashboard', [PrincipalController::class, 'index'])->name('dashboard');
    Route::get('/foto/{id}', [PrincipalController::class, 'show']);
    Route::post('/upload/foto', [PrincipalController::class, 'upload']);
    Route::post('/upload/defecto', [PrincipalController::class, 'defecto']);
    Route::post('/upload/google', [PrincipalController::class, 'googlefoto']);
    Route::prefix('json')->group(function () {
        Route::get('/usuario', [UsuarioController::class, 'js']);
    });
    Route::resource('/firma', FirmasController::class);

    Route::resource('/limpieza', LimpiezaController::class);
});

Route::controller(GoogleController::class)->group(function(){
    Route::get('auth/google', 'redirectToGoogle')->name('auth.google');
    Route::get('auth/google/callback', 'handleGoogleCallback');
});
