import './bootstrap';
import '../css/app.css';
import '@formkit/themes/genesis'
import '@formkit/pro/genesis'

import { createApp, h } from 'vue';
import { createInertiaApp } from '@inertiajs/vue3';
import { resolvePageComponent } from 'laravel-vite-plugin/inertia-helpers';
import { ZiggyVue } from '../../vendor/tightenco/ziggy';
import config from './formkit.config.js'
import { plugin as FKp, defaultConfig as PKdc } from '@formkit/vue'
import { createProPlugin, inputs } from '@formkit/pro'
import VueSweetalert2 from 'vue-sweetalert2';
import 'sweetalert2/dist/sweetalert2.min.css';
import PrimeVue from 'primevue/config';
import Lara from '@/presets/lara';
import Wind from '@/presets/wind';
import 'primevue/resources/themes/aura-light-green/theme.css'
import 'primeicons/primeicons.css'

const appName = import.meta.env.VITE_APP_NAME || 'Laravel';
const pro = createProPlugin('fk-511015e109', inputs)

createInertiaApp({
    title: (title) => `${title} - ${appName}`,
    resolve: (name) => resolvePageComponent(`./Pages/${name}.vue`, import.meta.glob('./Pages/**/*.vue')),
    setup({ el, App, props, plugin }) {
        return createApp({ render: () => h(App, props) })
            .use(plugin)
            .use(FKp, PKdc({ plugins: [pro] }))
            .use(ZiggyVue)
            .use(PrimeVue, {
                unstyled: false,
                pt: Lara
            })
            .use(VueSweetalert2)
            .mount(el);
    },
    progress: {
        color: '#4B5563',
    },
});
