<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Persona extends Model
{
//    protected $connection = 'cloud';
    protected $table = 'sistema_persona';
    protected $fillable = [
        'usuario_id',
        'nombre',
        'apellido_paterno',
        'apellido_materno',
        'cargo',
        'codigo',
        'genero',
        'estado',
        'birthday_at',
        'entry_at',
        'dni',
        'telefono',
        'correo_personal',
        'area',
        'remover',
        'profesion',
        'hijos',
        'bienvenida'
    ];
    protected $appends = ['nombre_completo', 'apellidos'];
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'created_at', 'updated_at', 'deleted_at','id','usuario_id','remover','bienvenida','correo_personal'
    ];

    public function usuario()
    {
        return $this->belongsTo('App\Models\Usuario', 'usuario_id', 'id');
    }
    public function getNombreCompletoAttribute()
    {
        return "{$this->apellido_paterno} {$this->apellido_materno}, {$this->nombre}";
    }
    public function getApellidosAttribute()
    {
        return "{$this->apellido_paterno} {$this->apellido_materno}";
    }
}
