<?php

namespace App\Imports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Carbon\Carbon;

class ImportarEstudiantes implements ToCollection, WithHeadingRow
{
    /**
    * @param Collection $collection
    */
    public function collection(Collection $rows)
    {
        $items=[];
      foreach ($rows as $row){
          $items[] =[
              'id' => $row['id'],
              'nombre' => $row['nombre'],
              'codigo' => $row['codigo'],
              'fecha_inscripcion' => Carbon::parse($row['fecha_inscripcion']),
          ];
      }

      return $items;
    }
}
