<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Imports\ImportarEstudiantes;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Facades\Excel;
use GuzzleHttp\Client as Guzzle;
use GuzzleHttp\Exception\ClientException;
use GuzzleHttp\RequestOptions as RequestOptions;
use App\Models\Usuario;
use Illuminate\Support\Facades\Log;

class LimpiezaController extends Controller
{
    public function index(Request $request)
    {
        $Resultados = $this->ListarUsuarios($request->input('pagina'));
        foreach ($Resultados->users as $Usuario){
            $Fechador = Carbon::parse($Usuario->creationTime)->diff(Carbon::now())->days;
            if($Usuario->lastLoginTime == '1970-01-01T00:00:00.000Z' AND (730 - $Fechador) <= 0){
                Log::debug('Correo: '.$Usuario->primaryEmail.' / Fecha: '.$Usuario->creationTime.' / Fechador: '.$Fechador.' / Exceso: '.(730 - $Fechador));
                $google = $this->Google('instituto');
                $delete_google = new \Google_Service_Directory($google);
                $delete_google->users->delete($Usuario->primaryEmail);
            }

        }
        return redirect('/limpieza?pagina='.$Resultados->nextPageToken);
        // $resultados = $this->ListarUsuarios();
    }
    public function ListarUsuarios($pagetoken = '')
    {
        $google = $this->Google('instituto');
        $service_google = new \Google_Service_Directory($google);
        return $service_google->users->listUsers([
            'viewType' => 'admin_view',
            'domain' => 'khipu.edu.pe',
            'maxResults' => 500,
            'pageToken' => $pagetoken
        ]);
    }
    /**
     * Show the form for creating a new resource.
     */
    public function buscarMatriculas($id)
    {
        $Cliente = self::guzzlePost('get', "{ prialumnoByCodigo(Codigo:\"".$id."\"){ IdAlumno Alumno Codigo matmatriculas{IdMatricula} }}");
        return (isset($Cliente['data']['prialumnoByCodigo']) ? count($Cliente['data']['prialumnoByCodigo']['matmatriculas']) : 0);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
    public static function guzzlePost($type, $query, $params = [])
    {
        $Cliente = new Guzzle;
        $ResponseApi = $Cliente->{$type}(
            'https://academico.khipu.edu.pe/public/graphql',[
            RequestOptions::JSON => [
                "query" => $query,
                "variables" => $params
            ]
        ]);
        try {
            return json_decode($ResponseApi->getBody()->getContents(), TRUE);
        } catch (ClientException $e) {
            echo Psr7\str($e->getRequest());
            echo Psr7\str($e->getResponse());
        }
    }
    public function ObtenerUnidad($correo)
    {
        $dominio = substr($correo, strpos($correo, '@') + 1);
        switch ($dominio) {
            case 'khipu.net':
            case 'incalab.org':
            case 'khipu.plus':
                $unidad = 'corporacion';
                break;
            case 'khipu.edu.pe':
                $unidad = 'instituto';
                break;
            case 'escuelakhipu.edu.pe':
            default:
                $unidad = 'escuela';
                break;
        }
        return $unidad;
    }
    public function Google($unidad){
        $client = new \Google_Client();
        $client->setApplicationName('GSuiteAdministrador');
        $client->setIncludeGrantedScopes(true);
        $client->setScopes([
            \Google_Service_Directory::ADMIN_DIRECTORY_USER,
            \Google_Service_Directory::ADMIN_DIRECTORY_USER_READONLY,
            //\Google_Service_Directory::ADMIN_DIRECTORY_MEMBER,
            //\Google_Service_Directory::ADMIN_DIRECTORY_USERNAME,
            \Google_Service_Directory::ADMIN_DIRECTORY_GROUP,
            \Google_Service_Directory::ADMIN_DIRECTORY_GROUP_MEMBER
        ]);
//        $client->setScopes([
//            'https://www.googleapis.com/auth/admin.directory.user',
//            'https://www.googleapis.com/auth/admin.directory.user.readonly',
//            'https://www.googleapis.com/auth/cloud-platform'
//        ]);
        $client->setAuthConfig(storage_path('app').'/json/'.$unidad.'/credentials.json');
        $client->setAccessType('offline');
        $client->setPrompt('select_account consent');
        $tokenPath = storage_path('app').'/json/'.$unidad.'/token.json';

        if (file_exists($tokenPath)) {
            $accessToken = json_decode(file_get_contents($tokenPath), true);
            $client->setAccessToken($accessToken);
        }
        if ($client->isAccessTokenExpired()) {
            // Refresh the token if possible, else fetch a new one.
            if ($client->getRefreshToken()) {
                $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
            } else {
                $authCode = '';
                if ($authCode) {
                    $authUrl = $client->createAuthUrl();
                    return $authUrl;
                }
                $authCode = '4/RgGN9FQybQIqFdQS3Zywm4yyFrZP_HrJO2h8Rzp415EExzREgWhorBs';
                // Exchange authorization code for an access token.
                $accessToken = $client->fetchAccessTokenWithAuthCode($authCode);
//                print_r($accessToken);
                $client->setAccessToken($accessToken);
                // Check to see if there was an error.
                if (array_key_exists('error', $accessToken)) {
                    throw new Exception(join(', ', $accessToken));
                }
            }
            // Save the token to a file.
            if (!file_exists(dirname($tokenPath))) {
                mkdir(dirname($tokenPath), 0700, true);
            }
            file_put_contents($tokenPath, json_encode($client->getAccessToken()));
        }
        return $client;
    }
}
