<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Laravel\Socialite\Facades\Socialite;
use Exception;
use App\Models\Usuario;
use Illuminate\Support\Facades\Auth;
use App\Models\Identity;

class GoogleController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function redirectToGoogle()
    {
        return Socialite::driver('google')->redirect();
    }

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function handleGoogleCallback()
    {
        try {
            $user = Socialite::driver('google')->user();
            $finduser = Identity::whereProviderNombre('google')
                ->whereProviderId($user->id)
                ->first();
            if($finduser){
                Auth::login($finduser->usuario);
                return redirect()->intended('dashboard');

            }else{
                return ['Los usuarios son creados por jparedes@khipu.net'];
//                $newUser = Usuario::updateOrCreate(['email' => $user->email],[
//                    'name' => $user->name,
//                    'google_id'=> $user->id,
//                    'password' => encrypt('123456dummy')
//                ]);
//
//                Auth::login($newUser);
//
//                return redirect()->intended('dashboard');
            }

        } catch (Exception $e) {
            dd($e->getMessage());
        }
    }
}
